package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.ActivityFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.IpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.SkinFeatureDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;


/**
 * 皮肤特征，常规活动特征
 */
@AdvancedFeignClient
public interface RemoteSkinActFeatureService {

    /**
     * 获取皮肤特征
     *
     * @param skinId
     * @return SkinFeatureDto
     */
    SkinFeatureDto getSkinFeature(Long skinId);

    /**
     * 获取活动特征
     *
     * @param activityId
     * @return ActivityFeatureDto
     */
    ActivityFeatureDto getActicityFeature(Long activityId);
}
