package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * hbase 离线特征表（所有设备号）
 *
 * @author xugf 2020-10-30
 */
@Data
public class AdxDeviceFeatureOnlineDto implements Serializable {

    private static final long serialVersionUID = -7658170466011538340L;

    //当日竞价次数
    private Long dayBidPv;

    //当日曝光次数
    private Long dayExposurePv;

    //当日资源位下竞价次数
    private Long resourceDayBidPv;

    //当日资源位下曝光次数
    private Long resourceDayExposurePv;

    //当日资源位下点击次数
    private Long resourceDayClickPv;

    //当日资源位下活动访问
    private Long resourceDayActivityRequestPv;

    //当日资源位下参与次数
    private Long resourceDayActivityJoinPv;

    //当日资源位下广告曝光
    private Long resourceDayAdvertExposurePv;

    //当日资源位下点击次数
    private Long resourceDayAdvertClickPv;

    //当日点击次数
    private Long dayClickPv;

    //当日资源位下上次曝光素材id	
    private Long resourceLastExposureSlotMaterial;

    //当日资源位下上次点击素材id	
    private Long resourceLastClickSlotMaterial;

    //当日不同入口素材曝光	
    private Map<Long, Long> slotMaterialDayExposurePv = new HashMap<>();

    //当日不同入口素材点击	
    private Map<Long, Long> slotMaterialDayClickPv = new HashMap<>();

    //当日资源位下不同入口素材曝光	
    private Map<Long, Long> resourceSlotMaterialDayExposurePv = new HashMap<>();

    //当日资源位下不同入口素材点击	
    private Map<Long, Long> resourceSlotMaterialDayClickPv = new HashMap<>();


    //当日用户+资源位 素材id曝光序列 top30
    private List<Long> exResSckDaySeq;
    //当日用户+资源位 素材Id点击序列 top30
    private List<Long> clResSckDaySeq;

    //当日用户 素材曝光序列 list
    private List<Long> exSckDaySeq;
    //当日用户 素材点击序列 list
    private List<Long> clSckDaySeq;

}
