package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * hbase 离线特征表（所有设备号 + 广告位）
 * @author xugf 2020-10-30
 */
@Data
public class DeviceSlotFeatureOfflineDto implements Serializable {

    private static final long serialVersionUID = 5617351956271775780L;

    //SDK广告位素材标签-入口各素材标签曝光次数（最近28天）
    private Map<Long, Long> sdkSlotMaterialTagExposure28d;

    //SDK广告位素材标签-入口各素材标签曝光次数（最近7天）
    private Map<Long, Long> sdkSlotMaterialTagExposure7d;

    //SDK广告位素材标签-入口各素材标签点击次数（最近28天）
    private Map<Long, Long> sdkSlotMaterialTagClick28d;

    //SDK广告位素材标签-入口各素材标签点击次数（最近7天）
    private Map<Long, Long> sdkSlotMaterialTagClick7d;

    //SDK奖品标签-各奖品标签重复曝光次数（最近28天）
    private Map<Long, Long> sdkPrizesTagExposure28d;

    //SDK奖品标签-各奖品标签重复曝光次数（最近7天）
    private Map<Long, Long> sdkPrizesTagExposure7d;

    //SDK奖品标签-各奖品标签重复参与次数（最近28天）
    private Map<Long, Long> sdkPrizesTagJoin28d;

    //SDK奖品标签-各奖品标签重复参与次数（最近7天）
    private Map<Long, Long> sdkPrizesTagJoin7d;

    //SDK皮肤-各皮肤重复曝光次数（最近28天）
    private Map<Long, Long> sdkSkinsExposure28d;

    //SDK皮肤-各皮肤重复曝光次数（最近7天）
    private Map<Long, Long> sdkSkinsExposure7d;

    //SDK皮肤-各皮肤重复参与次数（最近28天）
    private Map<Long, Long> sdkSkinsJoin28d;

    //SDK皮肤-各皮肤重复参与次数（最近7天）
    private Map<Long, Long> sdkSkinsJoin7d;


    //API广告位素材标签-入口各素材标签曝光次数（最近28天）
    private Map<Long, Long> apiSlotMaterialTagExposure28d;

    //API广告位素材标签-入口各素材标签曝光次数（最近7天）
    private Map<Long, Long> apiSlotMaterialTagExposure7d;

    //API广告位素材标签-入口各素材标签点击次数（最近28天）
    private Map<Long, Long> apiSlotMaterialTagClick28d;

    //API广告位素材标签-入口各素材标签点击次数（最近7天）
    private Map<Long, Long> apiSlotMaterialTagClick7d;

    //API奖品标签-各奖品标签重复曝光次数（最近28天）
    private Map<Long, Long> apiPrizesTagExposure28d;

    //API奖品标签-各奖品标签重复曝光次数（最近7天）
    private Map<Long, Long> apiPrizesTagExposure7d;

    //API奖品标签-各奖品标签重复参与次数（最近28天）
    private Map<Long, Long> apiPrizesTagJoin28d;

    //API奖品标签-各奖品标签重复参与次数（最近7天）
    private Map<Long, Long> apiPrizesTagJoin7d;

    //API皮肤-各皮肤重复曝光次数（最近28天）
    private Map<Long, Long> apiSkinsExposure28d;

    //API皮肤-各皮肤重复曝光次数（最近7天）
    private Map<Long, Long> apiSkinsExposure7d;

    //API皮肤-各皮肤重复参与次数（最近28天）
    private Map<Long, Long> apiSkinsJoin28d;

    //API皮肤-各皮肤重复参与次数（最近7天）
    private Map<Long, Long> apiSkinsJoin7d;


}
