package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.AdxFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.FeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.OneIdDeviceIdFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.form.DMPForm;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.form.OneIdDeviceIdFeatureForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteFeatureService {

    /**
     * 获取device对应的实时和离线特征
     *
     * @param deviceId md5加密后的deviceId
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    FeatureDto getDeviceFeature(String deviceId, Long timeout);

    /**
     * 获取device对应的dpa活动所需实时和离线特征
     *
     * @param deviceId md5加密后的deviceId
     * @param imei     md5加密后的imei
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    FeatureDto getDpaFeature(String deviceId, String imei, Long timeout);

    /**
     * 获取device对应的素材推荐所需实时和离线特征
     *
     * @param deviceId md5加密后的deviceId
     * @param imei     md5加密后的imei
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    FeatureDto getSlotMaterialFeature(String deviceId, String imei, String slotId, Long timeout);

    /**
     * 获取device对应的adx实时和离线特征
     *
     * @param imei       md5加密后的imei
     * @param resourceId 资源位id
     * @param timeout    服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    AdxFeatureDto getAdxFeature(String imei, String resourceId, Long timeout);

    /**
     * 获取device对应的CDN素材推荐所需实时和离线特征
     *
     * @param deviceId md5加密后的deviceId
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    FeatureDto getCDNSlotMaterialFeature(String deviceId, String slotId, Long timeout);

    /**
     * 获取device和imei对应的实时和离线特征
     *
     * @param deviceId md5加密后的deviceId
     * @param imei     md5加密后的imei号
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    FeatureDto getDeviceAndImeiFeature(String deviceId, String imei, Long timeout);

    /**
     * nezha获取device和imei对应的实时和离线特征
     *
     * @param deviceId md5加密后的deviceId
     * @param imei     md5加密后的imei号
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    FeatureDto getDeviceAndImeiFeatureNezha(String deviceId, String imei, Long timeout);

    /**
     * 通过oneId、deviceId获取用户特征
     * RemoteDMPService.getImeiTag、RemoteOneIdFeatureService.getFeatureByOneIdAndImei接口合并
     *
     * @param oneIdDeviceIdFeatureForm
     * @param timeout                  熔断时间 毫秒
     * @return
     */
    OneIdDeviceIdFeatureDto getOneIdDeviceIdFeature(OneIdDeviceIdFeatureForm oneIdDeviceIdFeatureForm, Long timeout);

    /**
     * 获取设备号对应的标签和人群包以及用户行为数据
     * RemoteDMPService.getDeviceNewPkg、RemoteDMPService.getDeviceActionData接口合并
     *
     * @param dmpForm 入参
     * @param timeout 超时时间单位毫秒
     * @return 标签和人群包
     */
    DeviceTagDto getDevicePkgAndActionData(DMPForm dmpForm, Long timeout);


    /**
     * 获取设备号对应的算法验证人群包
     * @param deviceId
     * @param timeout
     * @return 人群包
     */
    List<String> getImeiAlgRtaTag(String deviceId, Long timeout);

}
