package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.ImeiFeatureDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteImeiFeatureService {

    /**
     * 获取基础标签集合
     * @param imei md5加密后的imei号
     * @return 基础标签集合
     */
    String getBasicAttributeList(String imei);

    /**
     * 获取基础特征
     * @param imei md5加密后的imei号
     * @return ImeiFeatureDto
     */
    ImeiFeatureDto getImeiBasicFeature(String imei);

    /**
     * 获取基础特征
     * @param imei md5加密后的imei号
     * @return ImeiFeatureDto
     */
    ImeiFeatureDto getImeiFeature(String imei);
}
