package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.OneIdAndIpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.OneIdFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.OneIdFeatureOfflineDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.form.OneIdFeatureForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteOneIdFeatureService {

    /**
     * 获取device对应的实时和离线特征
     *
     * @param oneId oneId
     * @param oneIdType 1:真实设备号的oneId,2:虚拟设备号的oneId
     * @param timeout 熔断时间 毫秒
     * @return OneIdFeatureOfflineDto
     */
    OneIdFeatureOfflineDto getOneIdFeature(String oneId, Integer oneIdType, Long timeout);

    /**
     * 获取oneId对应的实时和离线特征
     *
     * @param form 入参
     * @param timeout 熔断时间 毫秒
     * @return OneIdFeatureDto
     */
    OneIdFeatureDto getOneIdFeatureByOneId(OneIdFeatureForm form, Long timeout);

    /**
     * 通过imei获取对应的实时和离线特征
     *
     * @param form 入参
     * @param timeout 熔断时间 毫秒
     * @return OneIdFeatureDto
     */
    OneIdFeatureDto getFeatureByOneIdAndImei(OneIdFeatureForm form, Long timeout);

    /**
     * 通过oneId或者真实设备号获取ip信标库
     *
     * @param form 入参
     * @param timeout 熔断时间 毫秒
     * @return OneIdFeatureDto
     */
    OneIdAndIpFeatureDto getIpIspByOneIdAndImei(OneIdFeatureForm form, Long timeout);
}
