package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.RealDeviceLabelDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRealDeviceLabelService {

    /**
     * 获取真实设备号标签
     *
     * @param deviceId 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public RealDeviceLabelDto getRealDeviceLabel(String deviceId, Long timeout);

    /**
     * 获取真实设备号标签
     *
     * @param deviceId 真实设备号md5值
     * @param columns  hbase字段列表
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public RealDeviceLabelDto getRealDeviceLabelWithColumn(String deviceId, List<String> columns, Long timeout);

    /**
     * 获取设备号标签列表
     *
     * @param deviceId 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public List<String> getDeviceLabelList(String deviceId, Long timeout);

}
