package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xugf 入口素材数据
 */
@Data
public class SlotMaterialDto implements Serializable {

    private static final long serialVersionUID = 5366774594747407531L;

    //入口素材id
    private Long materialId;

    //入口素材当日曝光次数
    private Long todayExposurePV;

    //入口素材当日点击次数
    private Long todayClickPV;

    //入口素材最近7天曝光次数
    private Long weekExposurePV;

    //入口素材最近7天点击次数
    private Long weekClickPV;

    //入口素材最近28天曝光次数
    private Long monthExposurePV;

    //入口素材最近28天点击次数
    private Long monthClickPV;

    //入口素材距离上一次曝光的时间间隔 （计算周期：28天）
    private Integer monthExposureInterval;

    //入口素材距离上一次点击的时间间隔 （计算周期：28天）
    private Integer monthClickInterval;

    //入口素材曝光频繁时段(计算周期：28天, 取值范围: 0:凌晨 1:早上 2:上午 3:中午 4:下午 5:晚上 6:深夜)
    private Integer monthExposurePeriod;

    //入口素材点击频繁时段(计算周期：28天, 取值范围: 0:凌晨 1:早上 2:上午 3:中午 4:下午 5:晚上 6:深夜)
    private Integer monthClickPeriod;
}
