package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.AdxFeatureNewDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.AdxFeatureDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteAdxFeatureService {

    /**
     * 获取device对应的adx实时和离线特征
     *
     * @param imei       md5加密后的imei
     * @param resourceId 资源位id
     * @param timeout    服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    AdxFeatureDto getAdxFeature(String imei, String resourceId, Long timeout);

    /**
     * 获取device对应的adx实时和离线特征
     *
     * @param imei       md5加密后的imei
     * @param resourceId 资源位id
     * @param timeout    服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return FeatureDto
     */
    AdxFeatureNewDto getAdxFeatureNew(String imei, String resourceId, Long timeout);


}
