package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.IpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.OneIdAndIpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.form.OneIdFeatureForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteIpFeatureService {

    /**
     * 获取基础特征
     * @param ip
     * @return ImeiFeatureDto
     */
    IpFeatureDto getIpFeature(String ip);


    /**
     * 通过oneId或者真实设备号获取ip信标库
     *
     * @param form 入参
     * @param timeout 熔断时间 毫秒
     * @return OneIdFeatureDto
     */
    OneIdAndIpFeatureDto getIpIspByOneIdAndDeviceId(OneIdFeatureForm form, Long timeout);


}
