package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;
import sun.util.resources.cldr.mg.LocaleNames_mg;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * 活动推荐特征数据
 */
@Data
public class ActivityRecomDeviceFeatureDto implements Serializable {

    private static final long serialVersionUID = -6712914491465969275L;
    //实时数据
    //用户当天入口曝光次数
    private Long userExpPv;

    //当天活动访问次数 
    private Long userActReqPv;

    //用户当天发券次数
    private Long userAdvLaunchPv;

    //当天券计费点击次数
    private Long userAdvClkPv;

    //当天目标转化次数
    private Long userCvtPv;

    //当日活动id访问列表
    private List<String> userActReqList;

    //当日券行业id曝光列表
    private List<String> userAdvLaunchTradeList;

    //当日券行业id计费点击列表
    private List<String> userAdvClkTradeList;


    //用户基础特征
    //性别
    private String gender;

    //年龄
    private String age;

    //婚育情况
    private String marital;

    //常住城市
    private String permanentCity;

    //兴趣偏好
    private String interestPreference;

    //app安装列表
    private String appInstall;


    //教育水平
    private String education;

    //身份职业
    private String vocation;

    //车房情况
    private String property;

    //消费水平
    private String consumeLevel;


    //消费偏好
    private String consumePreference;

    //地域等级
    private String regionalLevel;

    //地理位置
    private String geoLocation;

    //手机操作系统
    private String osType;

    //手机品牌
    private String brandName;

    //手机价格区间
    private String priceSection;

    //手机当前网络状态
    private String networkType;

    //手机运营商
    private String isp;

    //媒体流量标签
    private String appFlowTag;

    //媒体行业标签
    private String appIndustryTag;

    //用户最近访问的城市
    private String visitCityLast;

    //用户最近访问的城市等级
    private String visitCityLastLevel;

    //常驻地城市等级
    private String stayCityLevel;

    //户籍地（城市）
    private String homeCity;

    //户籍城市等级
    private String homeCityLevel;


    //百度adx一级标签
    private String bdFirstTag;

    //百度adx二级标签
    private String bdSecondTag;

    //百度adx三级标签
    private String bdThirdTag;

    //百度adx四级标签
    private String bdFourthTag;

    //离线统计指标数据
    //用户历史1天请求次数
    private Long userReqPv1d;

    //用户历史1天入口曝光次数
    private Long userExpPv1d;

    //用户历史1天活动访问次数
    private Long userActReqPv1d;

    //用户历史1天发券次数
    private Long userAdvLaunchPv1d;

    //用户历史1天券计费点击次数
    private Long userAdvClkPv1d;

    //用户历史1天目标转化次数
    private Long userCvtPv1d;

    //用户历史14天请求次数
    private Long userReqPv14d;

    //用户历史14天入口曝光次数
    private Long userExpPv14d;

    //用户历史14天活动访问次数
    private Long userActReqPv14d;

    //用户历史14天发券次数
    private Long userAdvLaunchPv14d;

    //用户历史14天券计费点击次数
    private Long userAdvClkPv14d;

    //用户历史14天目标转化次数
    private Long userCvtPv14d;


    //用户历史180天请求次数
    private Long userReqPv180d;

    //用户历史180天入口曝光次数
    private Long userExpPv180d;

    //用户历史180天活动访问次数
    private Long userActReqPv180d;

    //用户历史180天发券次数
    private Long userAdvLaunchPv180d;

    //用户历史180天券计费点击次数
    private Long userAdvClkPv180d;

    //用户历史180天目标转化次数
    private Long userCvtPv180d;

    //用户历史活动id访问列表
    private List<String> userActReqList14d;

    //用户历史券行业id曝光列表
    private List<String> userAdvLaunchTradeList14d;

    //用户历史券行业id计费点击列表
    private List<String> userAdvClkTradeList14d;


}
