package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * hbase 实时和离线特征表（真实设备号）
 * @author xugf 2020-10-30
 */
@Data
public class IpFeatureDto implements Serializable {

    private static final long serialVersionUID = -7189551252657298924L;

    //省份
    private  String province;

    //城市
    private  String city;

    //区
    private  String district;

    //街道
    private  String street;

    //网络状态
    private  String netType ;

    //运营商 1-移动 2-联通 3-电信
    private Integer isp ;

    //'ip精度定位 2-省份，3-城市，4-区县，5-街道',
    private Integer ipLevel ;

    //'城市等级 0-一线，1-新一线，2-二线，3-三线，4-四线，5-五线 ',
    private Integer cityLevel;

    // '归属大区 1-华东2-华北3-华南4-华中5-东北6-西北7-西南8-港澳台'
    private Integer region;

}
