package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * rta人群包基础数据类型
 */
@Data
public class RtaCrowdPackageDto implements Serializable {

    /**
     * rta人群包
     */
    private List<String> crowIds;

    /**
     * 广告主返回的人群包时间戳,单位秒
     */
    private Long timeStamp;

    /**
     * RTA广告主dmpKey，例如：phoneBaidu
     * @see cn.com.duiba.bigdata.online.service.api.remoteservice.RemoteDMPService#queryExternalDmpInfoList()
     */
    private String dmpKey;

}
