package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * hbase 离线特征表（所有设备号）
 * @author xugf 2020-10-30
 */
@Data
public class AdxDeviceFeatureOfflineDto implements Serializable {

    private static final long serialVersionUID = -7658170466011538340L;

    //历史7天竞价次数
    private Long weekBidPv;

    //历史7天曝光次数
    private Long weekExposurePv;

    //历史7天点击次数
    private Long weekClickPv;

    //历史7天素材曝光序列
    private String weekSlotMaterialExposureSeq;

    //历史7天素材点击序列
    private String weekSlotMaterialClickSeq;

    //历史7天不同资源位竞价次数
    private Map<Long, Long> resourceWeekBidPv;

    //历史7天不同资源位曝光次数
    private Map<Long, Long> resourceWeekExposurePv;

    //历史28天不同资源位曝光次数
    private Long resource28DayExposurePv;

    //历史7天不同资源位点击次数
    private Map<Long, Long> resourceWeekClickPv;

    //历史28天不同资源位点击次数
    private Long resource28DayClickPv;

    //历史7天不同资源位活动访问
    private Long resourceWeekActivityRequestPv;

    //历史28天不同资源位活动访问
    private Long resource28DayActivityRequestPv;

    //历史7天不同资源位活动参与
    private Long resourceWeekActivityJoinPv;

    //历史28天不同资源位活动参与
    private Long resource28DayActivityJoinPv;

    //历史7天不同资源位广告曝光
    private Long resourceWeekAdvertExposurePv;

    //历史28天不同资源位广告曝光
    private Long resource28DayAdvertExposurePv;

    //历史7天不同资源位广告点击
    private Long resourceWeekAdvertClickPv;

    //历史28天不同资源位广告点击
    private Long resource28DayAdvertClickPv;

    //历史28天不同资源位广告点击
    private Long day28ExposurePv;

    //历史28天不同资源位广告点击
    private Long day28ClickPv;

    //历史7天不同推广组竞价次数
    private Map<Long, Long> groupWeekBidPv;

    //历史7天不同推广组曝光次数
    private Map<Long, Long> groupWeekExposurePv;

    //历史7天不同推广组点击次数
    private Map<Long, Long> groupWeekClickPv;

    //广告行业曝光次数7天
    private Map<Long, Long> resourceTrade7DayExposurePv;

    //广告行业点击次数7天
    private Map<Long, Long> resourceTrade7DayClickPv;

    //广告行业曝光次数28天
    private Map<Long, Long> resourceTrade28DayExposurePv;

    //广告行业点击次数28天 Trade7DayExposurePv
    private Map<Long, Long> resourceTrade28DayClickPv;


    //广告行业曝光次数7天
    private Map<Long, Long> trade7DayExposurePv;

    //广告行业点击次数7天
    private Map<Long, Long> trade7DayClickPv;

    //广告行业曝光次数28天
    private Map<Long, Long> trade28DayExposurePv;

    //广告行业点击次数28天
    private Map<Long, Long> trade28DayClickPv;

    //用户时间间隔
    private Map<String, Long> timeInterval;


}
