package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * hbase 离线特征表（所有设备号）
 *
 * @author xugf 2020-10-30
 */
@Data
public class AdxDeviceFeatureOnlineDto implements Serializable {

    private static final long serialVersionUID = -7658170466011538340L;

    //当日竞价次数
    private Long dayBidPv;

    //当日曝光次数
    private Long dayExposurePv;

    //当日资源位下竞价次数
    private Long resourceDayBidPv;

    //当日资源位下曝光次数
    private Long resourceDayExposurePv;

    //当日资源位下点击次数
    private Long resourceDayClickPv;

    //当日资源位下活动访问
    private Long resourceDayActivityRequestPv;

    //当日资源位下参与次数
    private Long resourceDayActivityJoinPv;

    //当日资源位下广告曝光
    private Long resourceDayAdvertExposurePv;

    //当日资源位下点击次数
    private Long resourceDayAdvertClickPv;

    //当日点击次数
    private Long dayClickPv;

    //当日资源位下上次曝光素材id	
    private Long resourceLastExposureSlotMaterial;

    //当日资源位下上次点击素材id	
    private Long resourceLastClickSlotMaterial;

    //当日不同入口素材曝光	
    private Map<Long, Long> slotMaterialDayExposurePv = new HashMap<>();

    //当日不同入口素材点击	
    private Map<Long, Long> slotMaterialDayClickPv = new HashMap<>();

    //当日资源位下不同入口素材曝光	
    private Map<Long, Long> resourceSlotMaterialDayExposurePv = new HashMap<>();

    //当日资源位下不同入口素材点击	
    private Map<Long, Long> resourceSlotMaterialDayClickPv = new HashMap<>();


    //当日用户+资源位 素材id曝光序列 top30
    private List<Long> exResSckDaySeq;
    //当日用户+资源位 素材Id点击序列 top30
    private List<Long> clResSckDaySeq;

    //当日用户 素材曝光序列 list
    private List<Long> exSckDaySeq;
    //当日用户 素材点击序列 list
    private List<Long> clSckDaySeq;


    //adx用户兴趣特征
    //用户当天请求的推广组id-List
    private Set<String> userReqGroupSet;

    //用户当天请求的资源位id-List
    private Set<String> userReqResourceSet;

    //用户当天请求的外部联盟小媒体id-List
    private Set<String> userReqExtAppSet;

    //用户当天请求的外部联盟广告位id-List
    private Set<String> userReqExtSlotSet;

    //用户当天返回的推广组id-List
    private Set<String> userResGroupSet;

    //用户当天返回的资源位id-List
    private Set<String> userResResourceSet;

    //用户当天返回的外部联盟小媒体id-List
    private Set<String> userResExtAppSet;

    //用户当天返回的外部联盟广告位id-List
    private Set<String> userResExtSlotSet;

    //用户当天曝光的推广组id-List
    private Set<String> userExposureGroupSet;

    //用户当天曝光的资源位id-List
    private Set<String> userExposureResourceSet;

    //用户当天曝光的外部联盟小媒体id-List
    private Set<String> userExposureExtAppSet;

    //用户当天曝光的外部联盟广告位id-List
    private Set<String> userExposureExtSlotSet;

    //用户当天活动请求的推广组id-List
    private Set<String> userActReqGroupSet;

    //用户当天活动请求的资源位id-List
    private Set<String> userActReqResourceSet;

    //用户当天活动请求的外部联盟小媒体id-List
    private Set<String> userActReqExtAppSet;

    //用户当天活动请求的外部联盟广告位id-List
    private Set<String> userActReqExtSlotSet;

    //用户当天活动参与的推广组id-List
    private Set<String> userActJoinGroupSet;

    //用户当天活动参与的资源位id-List
    private Set<String> userActJoinResourceSet;

    //用户当天活动参与的外部联盟小媒体id-List
    private Set<String> userActJoinExtAppSet;

    //用户当天活动参与的外部联盟广告位id-List
    private Set<String> userActJoinExtSlotSet;

    //用户当天点券的推广组id-List
    private Set<String> userEffectClickGroupSet;

    //用户当天点券的资源位id-List
    private Set<String> userEffectClickResourceSet;

    //用户当天点券的外部联盟小媒体id-List
    private Set<String> userEffectClickExtAppSet;

    //用户当天点券的外部联盟广告位id-List
    private Set<String> userEffectClickExtSlotSet;

    //用户当天转化的推广组id-List
    private Set<String> userTargetEffectGroupSet;

    //用户当天转化的资源位id-List
    private Set<String> userTargetEffectResourceSet;

    //用户当天转化的外部联盟小媒体id-List
    private Set<String> userTargetEffectExtAppSet;

    //用户当天转化的外部联盟广告位id-List
    private Set<String> userTargetEffectExtSlotSet;
    
    
}
