package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * hbase 离线特征表（所有设备号）
 *
 * @author jackxueman 2022-01-19
 */
@Data
public class DeviceFeatureOfflineNewDto implements Serializable {

    //adx
    //历史7天竞价次数
    private Long adxRequest7d;

    //历史7天曝光次数
    private Long adxExposure7d;

    //历史7天点击次数
    private Long adxClick7d;

    //历史7天素材曝光序列
    private String adxSlotMaterialExposureSeq7d;

    //历史7天素材点击序列
    private String adxSlotMaterialClickSeq7d;

    //adx-资源位
    //历史7天不同资源位竞价次数
    private Map<Long, Long> adxResourceRequest7d;

    //历史7天不同资源位曝光次数
    private Map<Long, Long> adxResourceExposure7d;

    //历史7天不同资源位点击次数
    private Map<Long, Long> adxResourceClick7d;

    // adx-推广组
    //历史7天不同 推广组竞价次数
    private Map<Long, Long> adxGroupRequest7d;

    //历史7天不同 推广组曝光次数
    private Map<Long, Long> adxGroupExposure7d;

    //历史7天不同 推广组点击次数
    private Map<Long, Long> adxGroupClick7d;

    //活动访问-活动访问次数（最近28天）
    private Long activityRequest28d;

    //活动访问-活动访问次数（最近14天）
    private Long activityRequest14d;

    //活动访问-活动访问次数（最近7天）
    private Long activityRequest7d;

    //活动访问-活动访问次数（最近1天）
    private Long activityRequest1d;

    //活动访问-距离上一次活动访问时间间隔，单位：天（最近28天）
    private Integer activityRequestInterval28d;

    //活动参与-活动参与次数（最近28天）
    private Long activityJoin28d;

    //活动参与-活动参与次数（最近7天）
    private Long activityJoin7d;

    //活动参与-距离上一次活动参与时间间隔，单位：天（最近28天）
    private Integer activityJoinInterval28d;

    //综合行业（新行业）
    //综合行业（新行业）- 不同行业上发券数量（最近28天）
    private Map<Integer, Long> newAdvertIndustryLaunch28d;

    //综合行业（新行业）- 不同行业上发券数量（最近7天）
    private Map<Integer, Long> newAdvertIndustryLaunch7d;

    //综合行业（新行业）- 上一次发券行业
    private Integer newAdvertIndustryLaunchLast;

    //综合行业（新行业）- 上一次发券是否点击
    private Integer newAdvertIndustryEffectClickSwitch;

    //综合行业（新行业）- 不同行业上计费点击数量（最近28天）
    private Map<Integer, Long> newAdvertIndustryEffectClick28d;

    //综合行业（新行业）- 不同行业上计费点击数量（最近7天）
    private Map<Integer, Long> newAdvertIndustryEffectClick7d;

    //综合行业（新行业）- 上一次计费点击行业
    private Integer newAdvertIndustryEffectClickLast;

    //综合行业（新行业）- 上一次计费点击是否转化
    private Integer newAdvertIndustryLPClickSwitch;


    //广告券
    //活跃天数（最近14天）
    private Integer activeDay14d;

    //发券-距离上一次发券时间间隔，单位：天（最近28天）
    private Integer launchInterval28d;

    //发券-发券频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer launchPeriod28d;

    //历史1天发券次数
    private Long advertLaunch1d;

    //历史7天发券次数
    private Long advertLaunch7d;

    //历史14天发券次数
    private Long advertLaunch14d;

    //券曝光
    //广告曝光（最近7天）
    private Long advertExposoure7d;

    //广告曝光（最近28天）
    private Long advertExposoure28d;

    //券点击
    //计费点击-距离上一次计费点击时间间隔，单位：天（最近28天）
    private Integer advertEffectClickInterval28d;

    //计费点击-计费点击频繁时段：凌晨、早上、上午、中午、下午、晚上、深夜（最近28天）
    private Integer advertEffectClickPeriod28d;

    //广告点击次数（最近1天）
    private Long advertEffectClick1d;

    //广告点击次数（最近7天）
    private Long advertEffectClick7d;

    //广告点击次数（最近14天）
    private Long advertEffectClick14d;

    //广告点击次数（最近28天）
    private Long advertEffectClick28d;

    //用户历史序列特征（截断到20个，初始化近14天数据）
    //用户历史创意id曝光列表
    private Set<String> creativePlanExposureSet;

    //用户历史创意id点击列表
    private Set<String> creativePlanClickSet;

    //用户历史活动id访问列表
    private Set<String> activityRequestSet;

    //用户历史活动id参与列表
    private Set<String> activityJoinSet;

    //用户历史券id曝光列表
    private Set<String> advertExposureSet;

    //用户历史券id计费点击列表
    private Set<String> advertEffectClickSet;

    //用户历史券行业id曝光列表
    private Set<String> advertTradeExposureSet;

    //用户历史券行业id计费点击列表
    private Set<String> advertTradeEffectClickSet;

    //广告位素材
    //历史1天请求次数
    private Long slotMaterialRequest1d;

    //历史7天请求次数
    private Long slotMaterialRequest7d;

    //历史14天请求次数
    private Long slotMaterialRequest14d;

    //广告位素材-入口素材曝光次数（最近14天）
    private Long slotMaterialExposure14d;

    //广告位素材-入口素材曝光次数（最近7天）
    private Long slotMaterialExposure7d;

    //广告位素材-入口素材曝光次数（最近1天）
    private Long slotMaterialExposure1d;

    //广告位素材-入口素材点击次数（最近14天）
    private Long slotMaterialClick14d;

    //广告位素材-入口素材点击次数（最近7天）
    private Long slotMaterialClick7d;

    //广告位素材-入口素材曝光次数（最近1天）
    private Long slotMaterialClick1d;

    //上次曝光的广告位id
    private String exposureSlotId;

    //上次曝光的外部创意id
    private String exposureExtIdeaId;

    //上次曝光的外部广告投放场景
    private String exposureExtAdPlace;

    //上次曝光的外部广告组id
    private String exposureExtAdvertGroupId;

    //上次曝光的外部广告计划id
    private String exposureExtAdvertId;

    //上次曝光的外部媒体id
    private String exposureExtUnionAppId;

    //上次曝光的媒体开户账号id
    private String exposureExtAccountId;

    //上次曝光的外部广告位id
    private String exposureExtUnionSlotId;

    //上次曝光的外部平台id
    private String exposureExtPlatform;

    //目标转化
    //用户历史1天目标转化次数
    private Long targetConversion1d;

    //用户历史7天目标转化次数
    private Long targetConversion7d;

    //用户历史14天目标转化次数
    private Long targetConversion14d;

    //广告消耗
    //用户历史1天消耗
    private Long advertConsume1d;

    //用户历史7天消耗
    private Long advertConsume7d;

    //用户历史14天消耗
    private Long advertConsume14d;

    //活动访问-活动访问次数（最近180天）
    private Long activityRequest180d;

    //历史180天发券次数
    private Long advertLaunch180d;

    //广告点击次数（最近180天）
    private Long advertEffectClick180d;

    //历史180天请求次数
    private Long slotMaterialRequest180d;

    //广告位素材-入口素材曝光次数（最近180天）
    private Long slotMaterialExposure180d;

    //用户历史180天目标转化次数
    private Long targetConversion180d;


    //adx用户兴趣特征
    //用户1天请求的推广组id-List
    private Set<String> userReqGroupSet1d;

    //用户1天请求的资源位id-List
    private Set<String> userReqResourceSet1d;

    //用户1天请求的外部联盟小媒体id-List
    private Set<String> userReqExtAppSet1d;

    //用户1天请求的外部联盟广告位id-List
    private Set<String> userReqExtSlotSet1d;

    //用户1天返回的推广组id-List
    private Set<String> userResGroupSet1d;

    //用户1天返回的资源位id-List
    private Set<String> userResResourceSet1d;

    //用户1天返回的外部联盟小媒体id-List
    private Set<String> userResExtAppSet1d;

    //用户1天返回的外部联盟广告位id-List
    private Set<String> userResExtSlotSet1d;

    //用户1天曝光的推广组id-List
    private Set<String> userExposureGroupSet1d;

    //用户1天曝光的资源位id-List
    private Set<String> userExposureResourceSet1d;

    //用户1天曝光的外部联盟小媒体id-List
    private Set<String> userExposureExtAppSet1d;

    //用户1天曝光的外部联盟广告位id-List
    private Set<String> userExposureExtSlotSet1d;

    //用户1天活动请求的推广组id-List
    private Set<String> userActReqGroupSet1d;

    //用户1天活动请求的资源位id-List
    private Set<String> userActReqResourceSet1d;

    //用户1天活动请求的外部联盟小媒体id-List
    private Set<String> userActReqExtAppSet1d;

    //用户1天活动请求的外部联盟广告位id-List
    private Set<String> userActReqExtSlotSet1d;

    //用户1天活动参与的推广组id-List
    private Set<String> userActJoinGroupSet1d;

    //用户1天活动参与的资源位id-List
    private Set<String> userActJoinResourceSet1d;

    //用户1天活动参与的外部联盟小媒体id-List
    private Set<String> userActJoinExtAppSet1d;

    //用户1天活动参与的外部联盟广告位id-List
    private Set<String> userActJoinExtSlotSet1d;

    //用户1天点券的推广组id-List
    private Set<String> userEffectClickGroupSet1d;

    //用户1天点券的资源位id-List
    private Set<String> userEffectClickResourceSet1d;

    //用户1天点券的外部联盟小媒体id-List
    private Set<String> userEffectClickExtAppSet1d;

    //用户1天点券的外部联盟广告位id-List
    private Set<String> userEffectClickExtSlotSet1d;

    //用户1天转化的推广组id-List
    private Set<String> userTargetEffectGroupSet1d;

    //用户1天转化的资源位id-List
    private Set<String> userTargetEffectResourceSet1d;

    //用户1天转化的外部联盟小媒体id-List
    private Set<String> userTargetEffectExtAppSet1d;

    //用户1天转化的外部联盟广告位id-List
    private Set<String> userTargetEffectExtSlotSet1d;


    //近7天特征
    //用户7天请求的推广组id-List
    private Set<String> userReqGroupSet7d;

    //用户7天请求的资源位id-List
    private Set<String> userReqResourceSet7d;

    //用户7天请求的外部联盟小媒体id-List
    private Set<String> userReqExtAppSet7d;

    //用户7天请求的外部联盟广告位id-List
    private Set<String> userReqExtSlotSet7d;

    //用户7天返回的推广组id-List
    private Set<String> userResGroupSet7d;

    //用户7天返回的资源位id-List
    private Set<String> userResResourceSet7d;

    //用户7天返回的外部联盟小媒体id-List
    private Set<String> userResExtAppSet7d;

    //用户7天返回的外部联盟广告位id-List
    private Set<String> userResExtSlotSet7d;

    //用户7天曝光的推广组id-List
    private Set<String> userExposureGroupSet7d;

    //用户7天曝光的资源位id-List
    private Set<String> userExposureResourceSet7d;

    //用户7天曝光的外部联盟小媒体id-List
    private Set<String> userExposureExtAppSet7d;

    //用户7天曝光的外部联盟广告位id-List
    private Set<String> userExposureExtSlotSet7d;

    //用户7天活动请求的推广组id-List
    private Set<String> userActReqGroupSet7d;

    //用户7天活动请求的资源位id-List
    private Set<String> userActReqResourceSet7d;

    //用户7天活动请求的外部联盟小媒体id-List
    private Set<String> userActReqExtAppSet7d;

    //用户7天活动请求的外部联盟广告位id-List
    private Set<String> userActReqExtSlotSet7d;

    //用户7天活动参与的推广组id-List
    private Set<String> userActJoinGroupSet7d;

    //用户7天活动参与的资源位id-List
    private Set<String> userActJoinResourceSet7d;

    //用户7天活动参与的外部联盟小媒体id-List
    private Set<String> userActJoinExtAppSet7d;

    //用户7天活动参与的外部联盟广告位id-List
    private Set<String> userActJoinExtSlotSet7d;

    //用户7天点券的推广组id-List
    private Set<String> userEffectClickGroupSet7d;

    //用户7天点券的资源位id-List
    private Set<String> userEffectClickResourceSet7d;

    //用户7天点券的外部联盟小媒体id-List
    private Set<String> userEffectClickExtAppSet7d;

    //用户7天点券的外部联盟广告位id-List
    private Set<String> userEffectClickExtSlotSet7d;

    //用户7天转化的推广组id-List
    private Set<String> userTargetEffectGroupSet7d;

    //用户7天转化的资源位id-List
    private Set<String> userTargetEffectResourceSet7d;

    //用户7天转化的外部联盟小媒体id-List
    private Set<String> userTargetEffectExtAppSet7d;

    //用户7天转化的外部联盟广告位id-List
    private Set<String> userTargetEffectExtSlotSet7d;



}
