package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xugf 2023-02-28
 * dmp标签和特征集合
 */
@Data
public class DmpFeatureDto implements Serializable {
    private static final long serialVersionUID = -1329108589656667371L;

    //设备号
    private String deviceId;

    //设备号类型（1:真实 2:虚拟）
    private Integer deviceIdType;

    //DMP用户标签（只包含真实设备号）
    private TBDeviceLabelDiDto labelDto;

    //实时特征-当天（真实设备号+虚拟设备号）
    private TBDeviceFeatureOnlineDiDto featureOnlineDto;

    //离线特征-最近7天（真实设备号+虚拟设备号）
    private TBDeviceFeatureOffline7dDiDto featureOffline7dDto;

    //离线特征-最近14天（真实设备号+虚拟设备号）
    private TBDeviceFeatureOffline14dDiDto featureOffline14dDto;

    //离线特征-最近30天（只包含真实设备号）
    private TBDeviceFeatureOffline30dDiDto featureOffline30dDto;

    //离线特征-最近180天（只包含真实设备号）
    private TBDeviceFeatureOffline180dDiDto featureOffline180dDto;

    //全局特征-adx资源位数据
    private TBDmpAdxResourceDiDto adxResourceDto;

    //全局特征-广告位数据
    private TBDmpSlotDiDto slotDto;

    //全局特征-媒体包数据
    private TBDmpAppPackageDiDto appPackageDto;


}
