package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * hbase 实时和离线特征表（真实设备号）
 *
 * @author xugf 2020-10-30
 */
@Data
public class ImeiFeatureDto implements Serializable {

    private static final long serialVersionUID = -7189551252657298924L;

    //性别
    private String sex;

    //年龄
    private String age;

    //婚恋
    private String marry;

    //消费水平
    private String consumeLevel;

    //基础标签集合
    private String basicAttributeList;

    //城市编码（根据ip地址，实时更新）
    private Integer cityCode;

    //省份（根据ip地址，实时更新）
    private String province;

    //城市（根据ip地址，实时更新）
    private String city;

    //区（根据ip地址，实时更新）
    private String area;

    //手机当前网络状态，取值：wife 2G 3G 4G（实时更新）
    private String networkType;

    //手机运营商
    private String isp;

    //所有app安装列表
    private String appList;

    //有效app安装列表
    private String effectAppList;

    //top500 app安装列表
    private String top500AppList;

    //每个类目下的app数
    private String categoryAppCount;

    //app embedding
    private String appFactor;

    //短信签名列表
    private String messages;

    //每个类目下的短信签名数
    private String categoryMessageCount;

    //基础标签
    private String basicTags;

    //adx频道
    private String adxChannel;


    //百度adx一级标签
    private String baiduAdxFirstTag;

    //百度adx二级标签
    private String baiduAdxSecondTag;

    //百度adx三级标签
    private String baiduAdxThirdTag;

    //百度adx四级标签
    private String baiduAdxFourthTag;

    //百度adx性别标签
    private String baiduAdxSex;

    //百度adx年龄标签
    private String baiduAdxAge;

    //爱奇艺adx性别标签
    private String aiqiyiAdxSex;

    //爱奇艺adx年龄标签
    private String aiqiyiAdxAge;

    //婚育状态
    private String marital;


}
