package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * hbase 离线特征表（所有设备号）
 *
 * @author jackxueman
 */
@Data
public class OneIdFeatureOfflineNewDto implements Serializable {

    private static final long serialVersionUID = 1510543069889149150L;


    //广告行业（一级行业/二级行业）- 不同行业上发券数量（历史所有）
    private Map<String, Long> advertMatchTagLaunchPv = new HashMap<>();

    //广告行业（一级行业/二级行业）- 不同行业上点击数量（历史所有）
    private Map<String, Long> advertMatchTagClickPv = new HashMap<>();

    //广告行业（一级行业/二级行业）- 不同行业上落地页转化数量（历史所有）
    private Map<String, Long> advertMatchTagEffectPv = new HashMap<>();



    //用户历史第几个订单序列/发券数
    private Long historyLaunch;

    //用户历史该活动第几个订单序列/发券数
    private Long historyActivityLaunch;

    //用户历史各广告发券数
    private Map<Integer, Long> historyAdvertLaunch = new HashMap<>();

    //用户历史各广告点击数
    private Map<Integer, Long> historyAdvertClick = new HashMap<>();

    //用户历史各广告转化数
    private Map<Integer, Long> historyAdvertEffect = new HashMap<>();

    //用户上次发券时间 yyyy-MM-dd HH:mm:ss
    private String lastLaunchTime;

    //用户该活动下上次发券时间 yyyy-MM-dd HH:mm:ss
    private String lastActivityLaunchTime;

    //用户上一次发券订单
    private String lastLaunchOrder;

    //用户上一次点击订单
    private String lastClickOrder;

    //用户该活动下上一次发券订单
    private String lastActivityLaunchOrder;

    //用户该活动下上一次点击订单
    private String lastActivityClickOrder;

    //用户前一单活动
    private String lastActivity;

    //用户前一单广告二级行业标签
    private String lastAdvertMatchTag;

    //用户与前一单资源是否相同
    private String lastResource;

    //用户广告曝光序列
    private Set<Integer> advertExposureSet = new HashSet<>();

    //用户广告点击序列
    private Set<Integer> advertClickSet = new HashSet<>();

    //用户广告主点击序列
    private Set<Integer> accountClickSet = new HashSet<>();

    //用户资源点击序列
    private Set<String> resourceClickSet = new HashSet<>();

    //用户行业点击序列
    private Set<Integer> tradeClickSet = new HashSet<>();

    //用户广告转化序列
    private Set<Integer> advertEffectSet = new HashSet<>();

    //用户广告主转化序列
    private Set<Integer> accountEffectSet = new HashSet<>();

    //用户资源转化序列
    private Set<String> resourceEffectSet = new HashSet<>();

    //用户行业转化序列
    private Set<Integer> tradeEffectSet = new HashSet<>();

    //媒体-美团历史30天券访问次数
    private Long meiTuanAdvertRequestPv30Day ;

    // 媒体-美团历史30天券曝光次数
    private Long meiTuanAdvertExpousrePv30Day ;

    // 媒体-美团历史30天券有效点击次数
    private Long meiTuanAdvertEffectClickPv30Day ;



}
