package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * @author xugf 2023-02-28
 * 离线特征-最近30天（只包含真实设备号）
 */
@Data
public class TBDeviceFeatureOffline30dDiDto implements Serializable {
    private static final long serialVersionUID = -6720602371014754783L;

    //adx竞价请求PV
    private Long T1801;

    //adx竞价返回PV
    private Long T1802;

    //adx曝光PV
    private Long T1803;

    //adx入口素材点击PV
    private Long T1804;

    //广告位访问PV
    private Long T1805;

    //活动参与PV
    private Long T1806;

    //券曝光PV
    private Long T1807;

    //券有效点击PV
    private Long T1808;

    //是否被启航拉活过(1-是，0-否)
    private Integer T1812;

    //被启航拉活次数
    private Long T1813;

    //是否被重要任务ID拉活过(1-是，0-否)
    private Integer T1814;

    //启航返回的用户平均质量分，取整数
    private Integer T1815;

    //是否被美团拉活过(1-是，0-否)
    private Integer T1816;

    //被美团拉活次数
    private Long T1817;

    //被拉活过的素材标题关键词列表
    private Set<String> T1818;

    //广告券-目标转化PV（排除CPC点击和消耗数据）
    private Long T1819;

    //广告券-理论消耗（排除CPC点击和消耗数据）
    private Long T1820;

    //活跃区县（top5）
    private Set<String> T1821;




    //广告行业-落地页转化PV key:广告行业id
    private Map<String, Long> T1809;

    //广告行业-注册转化PV(type=3) key:广告行业id
    private Map<String, Long> T1810;

    //广告行业-理论消耗 key:广告行业id
    private Map<String, Long> T1811;


}
