package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author xugf 2023-02-28
 * 实时特征（真实设备号+虚拟设备号）
 */
@Data
public class TBDeviceFeatureOnlineDiDto implements Serializable {
    private static final long serialVersionUID = 6261075126839525021L;

    //adx竞价请求PV
    private Long T1101;

    //adx竞价返回PV
    private Long T1102;

    //adx曝光PV
    private Long T1103;

    //adx入口素材点击PV
    private Long T1104;

    //广告位访问PV
    private Long T1105;

    //活动参与PV
    private Long T1106;

    //券曝光PV
    private Long T1107;

    //券有效点击PV
    private Long T1108;

    //首次adx竞价请求时间，unix时间戳(秒)
    private Long T1109;

    //首次活动访问时间
    private Long T1110;

    //广告行业ID (最新订单)
    private String T1111;

    //订单时间，unix时间戳(秒) (最新订单)
    private Long T1112;

    //活动ID (最新订单)
    private String T1113;

    //曝光订单号 (最新订单)
    private String T1114;

    //计费订单号 (最新订单)
    private String T1115;

    //券是否点击 0:没有点击 1:点击 (最新订单)
    private Integer T1116;

    //adx曝光时间（最近一次，格式化成unix时间戳）
    private Long T1121;

    //adx点击时间（最近一次，格式化成unix时间戳）
    private Long T1122;

    //前端目标转化pv
    private Long T1123;

    //后端目标转化pv
    private Long T1124;

    //广告券-目标转化pv（前端目标转化pv + 后端目标转化pv）
    private Long T1125;

    //前端转化消耗
    private Long T1126;

    //后端转化消耗
    private Long T1127;

    //广告券-理论消耗（前端转化消耗 + 后端转化消耗）
    private Long T1128;


    //广告行业-落地页转化PV key:广告行业id
    private Map<String, Long> T1117;

    //广告行业-注册转化PV(type=3) key:广告行业id
    private Map<String, Long> T1118;

    //广告行业-理论消耗 key:广告行业id
    private Map<String, Long> T1119;

    //活动id-活动访问PV key:活动id
    private Map<String, Long> T1120;


}
