package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * @author xugf 2023-02-28
 * DMP用户标签（只包含真实设备号）
 */
@Data
public class TBDeviceLabelDiDto implements Serializable {
    private static final long serialVersionUID = -571999774643859309L;

    //性别
    private String T1001;

    //年龄
    private String T1002;

    //婚育情况
    private String T1003;

    //兴趣标签
    private Set<String> T1004;

    //用户安装的AppList
    private Set<String> T1005;

    //App一级分类
    private Map<String, Long> T1006;

    //App二级分类
    private Map<String, Long> T1007;

    //百度新版标签
    private Set<String> T1008;

    //设备号对应的运营商 (1:移动 2:联通 3:电信)
    private String T1009;

    //手机号码归属的省份,例如 "浙江"
    private String T1010;

    //手机号码归属的城市,例如 "杭州"
    private String T1011;

    //oppo、爱奇艺 性别标签测试（010101:男 010102:女）
    private String T1012;

}
