package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBackendOrderService {

    /**
     * 判断后端转化订单是否存在
     * @param orderId 订单id
     * @param subTypeList 后端转化类型
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return true：存在 false：不存在
     */
    Boolean exist(String orderId, List<String> subTypeList, Long timeout);

}
