package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.CrowdPackageDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.MixCrowdPackageDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteCrowdPackageService {

    /**
     * 获取人群包（上传人群包+广告主RTA人群包）
     *
     * @param deviceId 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public CrowdPackageDto getCrowdPackage(String deviceId, Long timeout);

    /**
     * 获取上传人群包
     *
     * @param deviceId 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public List<String> getUploadCrowdPackage(String deviceId, Long timeout);

    /**
     * 获取RTA人群包，携带时间戳
     *
     * @param deviceId 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public MixCrowdPackageDto getRtaCrowdPackage(String deviceId, Long timeout);



    /**
     * 批量获取RTA人群包，携带时间戳
     *
     * @param deviceIdList 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public Map<String, MixCrowdPackageDto> getBatchRtaCrowdPackage(List<String> deviceIdList, Long timeout);


    /**
     * 获取人群包（上传人群包+广告主RTA人群包并携带时间戳）
     *
     * @param deviceId 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public MixCrowdPackageDto getMixCrowdPackage(String deviceId, Long timeout);

}
