package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceLabelDiDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteDmpFeatureService {

    /**
     * adx场景下的dmp特征
     * @param deviceId 设备号
     * @param deviceIdType 设备号类型（1:真实 2:虚拟）
     * @param resourceId adx资源位id
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return DmpFeatureDto
     */
    DmpFeatureDto getAdxFeature(String deviceId, Integer deviceIdType, Long resourceId, Long timeout);

    /**
     * 广告和活动场景下的dmp特征
     * @param deviceId 设备号
     * @param deviceIdType 设备号类型（1:真实 2:虚拟）
     * @param slotId 广告位id
     * @param appPackageEn app的包名，英文名称
     * @param timeout  服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return DmpFeatureDto
     */
    DmpFeatureDto getFeature(String deviceId, Integer deviceIdType, Long slotId, String appPackageEn, Long timeout);

    /**
     * 查询真实设备号下的运营商数据，虚拟设备号返回null
     * @param deviceId 设备号
     * @param deviceIdType 设备号类型（1:真实 2:虚拟）
     * @param timeout 服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return 运营商 (1:移动 2:联通 3:电信 null:查询不到数据)
     */
    String getIsp(String deviceId, Integer deviceIdType, Long timeout);

    /**
     * 查询真实设备号下的标签数据，虚拟设备号返回null
     * @param deviceId 设备号
     * @param deviceIdType 设备号类型（1:真实 2:虚拟）
     * @param timeout 服务端熔断时间，单位毫秒，如果不需要服务端熔断，请设置 null
     * @return 设备号下的所有标签
     */
    TBDeviceLabelDiDto getDeviceLabel(String deviceId, Integer deviceIdType, Long timeout);


}
