package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.RtaDeviceFeatureDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author jackxueman
 */
@AdvancedFeignClient
public interface RemoteRtaDeviceFeatureService {

    /**
     * 获取设备号标签/特征
     *
     * @param deviceId 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public RtaDeviceFeatureDto getDeviceLabelAndFeature(String deviceId, Long timeout);


    /**
     * 北京RTA 获取设备号标签/特征
     *
     * @param deviceId 真实设备号md5值
     * @param timeout  超时时间，单位毫秒
     * @return
     */
    public RtaDeviceFeatureDto getDeviceLabelAndFeatureForBJ(String deviceId, Long timeout);

}
