package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.inner.service.api.dto.*;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteDimensionFeatureService {


    /**
     * 获取广告位行为特征
     *
     * @return行为画像
     */
    SlotFeatureDto getSlotFeatureById(Long slotId);

    /**
     * 获取媒体行为特征
     *
     * @return行为画像
     */
    AppFeatureDto getAppFeatureById(Long appId);


    /**
     * 获取皮肤行为特征
     *
     * @return行为画像
     */
    SkinFeatureDto getSkinFeatureById(Long skinId);


    /**
     * 获取活动行为特征
     *
     * @return行为画像
     */
    ActivityFeatureDto getActFeatureById(Long actId);


    /**
     * 获取广告位素材特征
     *
     * @return行为画像
     */
    SlotMaterialFeatureDto getSlotMaterialFeatureById(Long slotMaterialId);


    /**
     * 获取标题行为特征
     *
     * @return行为画像
     */
    TitleFeatureDto getTitleFeatureById(Long titleId, String titleType);


    /**
     * 获取奖品行为特征
     *
     * @return行为画像
     */
    PrizeFeatureDto getPrizeFeatureById(Long prizeId, String prizeType);

    /**
     * 获取广告位行为特征
     *
     * @return行为画像
     */
    List<SlotFeatureDto> getSlotFeature(List<Long> slotIds);

    /**
     * 获取广告位行为特征
     *
     * @return行为画像
     */
    List<AppFeatureDto> getAppFeature(List<Long> appIds);


    /**
     * 获取皮肤行为特征
     *
     * @return行为画像
     */
    List<SkinFeatureDto> getSkinFeature(List<Long> skinIds);


    /**
     * 获取活动行为特征
     *
     * @return行为画像
     */
    List<ActivityFeatureDto> getActFeature(List<Long> actIds);


    /**
     * 获取标题行为特征
     *
     * @return行为画像
     */
    List<TitleFeatureDto> getTitleFeature(String titleType, List<Long> titleIds);


    /**
     * 获取奖品行为特征
     *
     * @return行为画像
     */
    List<PrizeFeatureDto> getPrizeFeature(String prizeType, List<Long> prizeIds);


    /**
     * 获取广告位素材特征
     *
     * @return行为画像
     */
    List<SlotMaterialFeatureDto> getSlotMaterialFeature(List<Long> slotMaterialIds);



    /**
     * 获取广告位id
     *
     * @return行为画像
     */
    List<Long> getSlotIds();

    /**
     * 获取媒体id
     *
     * @return
     */
    List<Long> getAppIds();


    /**
     * 获取皮肤行为特征
     *
     * @return行为画像
     */
    List<Long> getSkinIds();


    /**
     * 获取活动行为特征
     *
     * @return行为画像
     */
    List<Long> getActIds();


    /**
     * 获取标题行为特征
     *
     * @return行为画像
     */
    List<Long> getTitleIds(String titleType);


    /**
     * 获取奖品行为特征
     *
     * @return行为画像
     */
    List<Long> getPrizeIds(String prizeType);


    /**
     * 获取广告位素材特征
     *
     * @return行为画像
     */
    List<Long> getSlotMaterialIds();

    /**
     * 获取广告标签兴趣分区间
     * @return
     */
    List<TBTradeTagRuleScopeDto> getTagScopeAll();

    /**
     * holo表analyze配置表
     * @return
     */
    List<AnalyzeHoloTableConfigDto> getHoloAnalyzeTables();
}
