package cn.com.duiba.bigdata.inner.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xugf
 * druid 返回结果转化的对象
 */
@Data
public class TestPlatformDataDto implements Serializable {

    private static final long serialVersionUID = -4453678442733558806L;

    //维度
    private String timeSegment;//统计时间段 格式(yyyy-MM-dd HH:mm:ss)
    private String slotId;//广告位id
    private String testGroupId;// '实验组ID',

    //指标
    private Long activityRequestUv;// '活动访问UV',
    private Long activityParticipateUv;//  '活动参与UV',
    private Long slotExposurePv;// '素材（广告位）曝光PV',
    private Long slotClickPv;// '素材（广告位）点击pv',
    private Long activityRequestPv;// '活动访问PV',
    private Long activityParticipatePv;// '活动参与PV',
    private Long advertRequestPv;// '券请求PV',
    private Long advertRequestTotal;// '券请求PV(含增值)',
    private Long advertLaunchPv;//  '发券PV',
    private Long payAdvertLaunchPv;// '付费券发券PV',
    private Long freeAdvertLaunchPv;//  '免费券发券PV',
    private Long riskCheatAdvertLaunchPv;// '作弊发券PV',
    private Long advertLaunchTotal;// '发券PV(含增值)',
    private Long payAdvertLaunchTotal;// '付费券发券PV(含增值)',
    private Long freeAdvertLaunchTotal;// '免费券发券PV(含增值)',
    private Long riskCheatAdvertLaunchTotal;// '作弊发券pv(含增值)',
    private Long advertExposurePv;// '券曝光PV',
    private Long advertExposureTotal;// '券曝光PV(含增值)',
    private Long advertEfClickPv;// '券计费点击PV',
    private Long advertEfClickTotal;//  '券计费点击PV(含增值)',
    private Long advertConsumeAmt;// '券消耗金额(分)',
    private Long advertConsumeAmtTotal;// '券消耗金额(含增值)(分)',
    private Long advertPromoteExposePv;// '落地页曝光PV',
    private Long advertPromoteChangePv;// '落地页转化PV',
}
