package cn.com.duiba.bigdata.inner.service.api.enums;

import com.google.common.collect.Lists;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xugf
 * druid指标字段
 */
public enum TestPlatformMetricEnum {
    MATERIAL_EXPOSURE_PV("slotExposurePv", "素材曝光pv"),

    MATERIAL_CLICK_PV("slotClickPv", "素材点击pv"),

    ACTIVITY_REQUEST_PV("activityRequestPv", "活动访问pv"),

    ACTIVITY_REQUEST_UV("activityRequestUv", "活动访问uv"),

    ACTIVITY_PARTICIPATE_PV("activityParticipatePv", "活动参与pv"),

    ACTIVITY_PARTICIPATE_UV("activityParticipateUv", "活动参与uv"),

    ADVERT_REQUEST_PV("advertRequestPv", "券请求pv"),

    ADVERT_REQUEST_TOTAL("advertRequestTotal", "券请求pv(含增值)"),

    ADVERT_LAUNCH_PV("advertLaunchPv", "发券量pv"),

    ADVERT_LAUNCH_TOTAL("advertLaunchTotal", "发券量pv(含增值)"),

    PAY_ADVERT_LAUNCH_PV("payAdvertLaunchPv", "付费券发券量pv"),

    PAY_ADVERT_LAUNCH_TOTAL("payAdvertLaunchTotal", "付费券发券量pv(含增值)"),

    FREE_ADVERT_LAUNCH_PV("freeAdvertLaunchPv", "免费券发券量pv"),

    FREE_ADVERT_LAUNCH_TOTAL("freeAdvertLaunchTotal", "免费券发券量pv(含增值)"),

    RISK_CHEAT_ADVERT_LAUNCH_PV("riskCheatAdvertLaunchPv", "作弊发券量pv"),

    RISK_CHEAT_ADVERT_LAUNCH_TOTAL("riskCheatAdvertLaunchTotal", "作弊发券pv(含增值)"),

    ADVERT_EXPOSURE_PV("advertExposurePv", "券曝光pv"),

    ADVERT_EXPOSURE_TOTAL("advertExposureTotal", "券曝光PV(含增值)"),

    ADVERT_EF_CLICK_PV("advertEfClickPv", "券计费点击PV"),

    ADVERT_EF_CLICK_TOTAL("advertEfClickTotal", "券计费点击PV(含增值)"),

    ADVERT_CONSUME_AMT("advertConsumeAmt", "券消耗金额(分)"),

    ADVERT_CONSUME_AMT_TOTAL("advertConsumeAmtTotal", "券消耗金额(含增值)(分)"),

    ADVERT_PROMOTE_EXPOSE_PV("advertPromoteExposePv", "落地页曝光pv"),

    ADVERT_PROMOTE_CHANGE_PV("advertPromoteChangePv", "落地页转化pv");


    //指标字段名称
    private String fieldName;

    //指标解释说明
    private String desc;

    TestPlatformMetricEnum(String fieldName, String desc) {
        this.fieldName = fieldName;
        this.desc = desc;
    }

    public static List<String> getAllMetrics() {
        List<String> list = Lists.newArrayList();
        for (TestPlatformMetricEnum metricEnum : TestPlatformMetricEnum.values()) {
            list.add(metricEnum.getFieldName());
        }
        return list;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getDesc() {
        return desc;
    }
}
