package cn.com.duiba.bigdata.inner.service.api.form;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
public class DruidDataQuery implements Serializable {

    private static final long serialVersionUID = 5487394549988878473L;

    /**
     * 场景ID
     */
    private Long id;

    /**
     * 查询指标
     */
    private List<String> quotaList;

    /**
     * 查询条件
     */
    private Map<String, String> searchMap;

    public DruidDataQuery(Long id, List<String> quotaList, Map<String, String> searchMap) {
        this.id = id;
        this.quotaList = quotaList;
        this.searchMap = searchMap;
    }

    public DruidDataQuery() {
    }

    @Override
    public String toString() {
        return "AnalyzeDataForm{" +
                "id=" + id +
                ", quotaList=" + quotaList +
                ", searchMap=" + searchMap +
                '}';
    }
}