package cn.com.duiba.bigdata.inner.service.api.form;

import cn.com.duiba.bigdata.common.biz.enums.DruidShowTypeEnum;
import cn.com.duiba.bigdata.inner.service.api.dto.KeyValueDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xugf
 * druid 数据查询对象
 */
@Data
public class DruidQueryForm implements Serializable {

    private static final long serialVersionUID = -4744585324615351360L;

    //查询的开始时间 时间格式: yyyy-MM-dd HH:mm:ss（必填）
    private String startTime;

    //查询的结束时间 时间格式: yyyy-MM-dd HH:mm:ss（必填）
    private String endTime;

    //本次查询的指标列表 取值参照 DruidMetricEnum（必填）
    private List<String> metricList;

    //本次查询的维度列表 取值参照 DruidDimensionEnum
    private List<String> dimensionList;

    //本次查询的条件 KeyValueDto中key的取值:DruidDimensionEnum
    private List<KeyValueDto> conditionList;

    //排序的指标 KeyValueDto中key的取值: DruidMetricEnum, value: DruidOrderByEnum
    private KeyValueDto orderByMetric;

    //数据展示格式, 默认直接返回查询时段内的所有数据，取值参照 DruidShowTypeEnum.code
    private String dataShowType = DruidShowTypeEnum.ALL.toString();
}
