package cn.com.duiba.bigdata.inner.service.api.form;

import cn.com.duiba.bigdata.common.biz.enums.HologresShowTypeEnum;
import cn.com.duiba.bigdata.inner.service.api.dto.KeyValueDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xugf
 * druid 数据查询对象
 */
@Data
public class HologresQueryForm implements Serializable {

    private static final long serialVersionUID = -4744585324615351360L;

    //查询的开始时间 时间格式: yyyy-MM-dd HH:mm:ss（必填）
    private String startTime;

    //查询的结束时间 时间格式: yyyy-MM-dd HH:mm:ss（必填）
    private String endTime;

    //本次查询的基础指标列表 取值参照 HologresMetricEnum（基础指标和计算类指标，必须要有一个）
    private List<String> metricList;

    //本次查询的计算类指标列表 取值参照 HologresCalculateMetricEnum
    private List<String> calculateMetricList;

    //本次查询的维度列表 取值参照 HologresDimensionEnum
    private List<String> dimensionList;

    //本次查询的条件 KeyValueDto中key的取值: HologresDimensionEnum
    private List<KeyValueDto> conditionList;

    //排序的指标 KeyValueDto中key的取值: HologresMetricEnum, value: HologresOrderByEnum
    private KeyValueDto orderByMetric;

    //数据展示格式, 默认直接返回查询时段内的所有数据，取值参照 HologresShowTypeEnum
    private String dataShowType = HologresShowTypeEnum.ALL.toString();

    //每页展示的记录条数
    private Integer pageSize;

    //当前页面号
    private Integer pageNumber;
}
