package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.common.biz.dto.DruidResultDto;
import cn.com.duiba.bigdata.common.biz.dto.HologresResultDto;
import cn.com.duiba.bigdata.inner.service.api.form.HologresQueryForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteHologresService {

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据（即将废弃，替换成queryOnline 或者 queryOffline）
     *
     * @param form 查询条件
     * @return DruidResultDto
     */
    @Deprecated
    List<DruidResultDto> query(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据 (实时数据接口)
     *
     * @param form 查询条件
     * @return HologresResultDto
     */
    List<HologresResultDto> queryOnline(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的条件，自动拼装sql，从hologres中查询数据 (离线数据接口)
     *
     * @param form 查询条件
     * @return HologresResultDto
     */
    List<HologresResultDto> queryOffline(HologresQueryForm form) throws Exception;

    /**
     * 根据传入的sql，从hologres中查询数据
     *
     * @param sql 查询sql
     * @return jsonArrayStr
     */
    String queryHoloSql(String sql) throws Exception;

    /**
     * analyze holo的表
     *
     * @param dataBase  数据库
     * @param tableName 表名
     * @throws Exception
     */
    void analyzeHoloTable(String dataBase, String tableName) throws Exception;


    /**
     * 获取holo库中分区表的所有分区数
     *
     * @param dataBaseName 库名
     * @param tableName    表名
     * @return 分区列表
     */
    List<String> getDataBaseTablePartitionList(String dataBaseName, String tableName) throws Exception;

    /**
     * 创建表的分区
     *
     * @param dataBaseName   库名
     * @param tableName      表名
     * @param partitionValue 分区值
     */
    void createDataBaseTablePartition(String dataBaseName, String tableName, Long partitionValue) throws Exception;

    /**
     * 删除表的分区
     *
     * @param dataBaseName   库名
     * @param tableName      表名
     * @param partitionValue 分区值
     */
    void dropDataBaseTablePartition(String dataBaseName, String tableName, Long partitionValue) throws Exception;

}
