package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.inner.service.api.dto.TestPlatformDataDto;
import cn.com.duiba.bigdata.inner.service.api.form.TestPlatForm;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteTestPlatformService {

    /**
     * 折线图、小时+实验组粒度
     *
     * @param form planId、单个metric
     * @return timeSegment+testGroupId+metric
     */
    List<TestPlatformDataDto> queryLineChartData(TestPlatForm form) throws BizException;

    /**
     * 实时数据分析 广告位对比
     *
     * @param form planId、testGroupIds、单个metrics
     * @return slotId+testGroupId+metric
     */
    List<TestPlatformDataDto> onlineAnalyseSlotCompare(TestPlatForm form) throws BizException;

    /**
     * 实时数据分析 指标涨跌top
     *
     * @param form planId、testGroupIds、所有metrics
     * @return testGroupId+metrics
     */
    List<TestPlatformDataDto> onlineAnalyseTopMetrics(TestPlatForm form) throws BizException;
}
