package cn.com.duiba.bigdata.inner.service.api.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class AppFeatureDto implements Serializable {
    private static final long serialVersionUID = -1L;

    // 媒体id
    private String appId;

    //素材二期特征
    //点击
    private String sdkMaterialTagClickCnt7; //各素材标签的点击次数 （7天）
    private String sdkMaterialTagClickCnt28;//各素材标签的点击次数 （历史）
    private String sdkSkinTypeJoinCnt7;//各皮肤类型的点击次数 （7天）
    private String sdkSkinTypeJoinCnt28;//各皮肤类型的点击次数 （历史）
    private String sdkActPrizeTagJoinCnt7;//各奖品标签的点击次数 （7天）
    private String sdkActPrizeTagJoinCnt28;//各奖品标签的点击次数 （历史）

    //曝光
    private String sdkMaterialTagExposeCnt7;//各素材标签的曝光次数 （7天）
    private String sdkMaterialTagExposeCnt28;//各素材标签的曝光次数 （历史）
    private String sdkSkinTypeRequestCnt7;//各皮肤类型的曝光次数 （7天）
    private String sdkSkinTypeRequestCnt28;//各皮肤类型的曝光次数 （历史）
    private String sdkActPrizeTagRequestCnt7;//各奖品标签的曝光次数 （7天）
    private String sdkActPrizeTagRequestCnt28;//各奖品标签的曝光次数 （历史）

    //API流量
    private String apiMaterialTagExposeCnt7;//'7天api素材各标签的曝光次数',
    private String apiMaterialTagExposeCnt28;//'28天api素材各标签的曝光次数',
    private String apiMaterialTagClickCnt7;//'7天api素材各标签的点击次数',
    private String apiMaterialTagClickCnt28;//'28天api素材各标签的点击次数',
    private String apiSkinTypeRequestCnt7;//'7天api各活动皮肤类型的曝光次数',
    private String apiSkinTypeRequestCnt28;//'28天api各活动皮肤类型的曝光次数',
    private String apiSkinTypeJoinCnt7;//'7天api各活动皮肤类型的参与次数',
    private String apiSkinTypeJoinCnt28;//'28天api各活动皮肤类型的参与次数',
    private String apiActPrizeTagRequestCnt7;//'7天api各活动奖品标签的曝光次数',
    private String apiActPrizeTagRequestCnt28;//'28天api各活动奖品标签的曝光次数',
    private String apiActPrizeTagJoinCnt7;//'7天api各活动奖品标签的参与次数',
    private String apiActPrizeTagJoinCnt28;//'28天api各活动奖品标签的参与次数',
}