package cn.com.duiba.bigdata.inner.service.api.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class SlotMaterialFeatureDto implements Serializable {
    private static final long serialVersionUID = -1L;

    private Long materialId;  // 广告位素材id

    private String exposurePvW; //素材过去7天在广告位上的曝光次数',
    private String clickPvW; //素材过去7天在广告位上的点击次数',
    private String promoteChangePvW; //历史7天各素材上的前端转化',
    private String backChangePvW; //历史7天后端转化次数

    private Long appSckExpUv14;// '素材过去14天曝光uv',
    private Long appSckClkUv14;// '素材过去14天点击uv',
    private Long appSckExpUv7;//素材过去7天曝光uv',
    private Long appSckClkUv7;//素材过去7天点击uv',
    private Long appSckExpUv3;//素材过去3天曝光uv',
    private Long appSckClkUv3;//素材过去3天点击uv',

    //API
    private Long apiExposurePvW;                //'api历史7天曝光次数-sdk',
    private Long apiClickPvW;                //'api历史7天点击次数-sdk',
    private Long apiPromoteChangePvW;                //'api历史7天前端转化-sdk',
    private Long apiBackChangePvW;                //'api历史7天后端转化次数-sdk',
    private Long apiAppSckExpUv14;                //'api素材过去14天曝光uv',
    private Long apiAppSckClkUv14;                //'api素材过去14天点击uv',
    private Long apiAppSckExpUv7;                //'api素材过去7天曝光uv',
    private Long apiAppSckClkUv7;                //'api素材过去7天点击uv',
    private Long apiAppSckExpUv3;                //'api素材过去3天曝光uv',
    private Long apiAppSckClkUv3;                //'api素材过去3天点击uv',

}