package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.inner.service.api.dto.AdvertBackTypeDto;
import cn.com.duiba.bigdata.inner.service.api.dto.AdvertOrderDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * @author xugf 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteAdvertBackTypeService {

    /**
     * 获取广告的回传类型
     *
     * @param advertList 广告集合
     * @return 广告回传类型
     */
    Map<Long, AdvertBackTypeDto> getAdvertBackType(List<Long> advertList);

    /**
     * 查询离线的广告回传类型
     *
     * @param date              起始日期
     * @param excludeAdvertList 排除的广告集合 可为空
     * @return 广告回传类型
     */
    Map<Long, AdvertBackTypeDto> getOfflineAdvertBackType(String date, List<Long> excludeAdvertList);
}
