package cn.com.duiba.bigdata.inner.service.api.form;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class DMPCrowdForm implements Serializable {
    /**
     * 人群包ID
     */
    private Long id;
    /**
     * 人群包ID
     */
    private Long crowdId;

    /**
     * 人群包详情表ID
     */
    private Long crowdDetailId;
    /**
     * 人群包名称
     */
    private String crowdName;
    /**
     * 人群包类型: 1私有人群包，2行业人群包
     */
    private Integer crowdType;
    /**
     * 创建方式：新建1，上传2，第三方厂家3，接口触发4
     */
    private Integer createType;
    /**
     * 创建人Id
     */
    private Long adminId;
    /**
     * 数据类型：IMEIMD5 --> 1，IMEI--> 2 ,IDFA--> 3,IDFAMD5--> 4,IDFA 5,IDFA-MD5 6
     */
    private Integer dataType;
    /**
     * 人群包创建时间
     */
    private String createTime;
    /**
     * 人群包有效状态: 计算中 1，计算完成 2，失败 3，更新中 4，更新完成 5，可查询 6
     */
    private Integer validState;
    /**
     * 人群包ID上传方式创建的人群包数据条数
     */
    private String upLoadCount;
    /**
     * 更新机制: 不更新1，自动更新2
     */
    private Integer updateStrategy=0;
    /**
     * 上传文件的url列表
     */
    private List<String> deviceInfos;
    /**
     * 基于类型: 基于广告1，基于用户2
     */
    private Integer baseType;
    /**
     * 开始时间
     */
    private String startTime;
    /**
     * 结束时间
     */
    private String endTime;
    /**
     * 推送状态：0 未推送，1 推送成功
     */
    private Integer isPush;
    /**
     * 是否自动推送:0 不推送，1 自动推送
     */
    private Integer isAutoPush;
    /**
     * 是否广告主创建：0 否，1是
     */
    private Integer isAccount;

    /**
     * 人群包Id集合
     */
    private List<Long> ids;

    private Integer pageNum;
    private Integer pageSize;
    private Integer pageCurrent;
}
