package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.common.biz.dto.HologresResultDto;
import cn.com.duiba.bigdata.inner.service.api.form.BigdataQueryForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf
 * 统一数据接口服务，包含实时和离线数据，面向内部管理系统使用，低qps场景
 */
@AdvancedFeignClient
public interface RemoteBigdataService {

    /**
     * 查询hologres中实时和离线的数据
     *
     * @param form 查询条件
     * @return HologresResultDto
     */
    List<HologresResultDto> queryHoloData(BigdataQueryForm form) throws Exception;

    /**
     * 查询hologres中实时集群数据
     *
     * @param form 查询条件
     * @return HologresResultDto
     */
    List<HologresResultDto> queryOnlineHoloData(BigdataQueryForm form) throws Exception;

    /**
     * 查询hologres中实时和离线的数据
     *
     * @param form 查询条件
     * @return HologresResultDto
     */
    List<HologresResultDto> queryHoloAndHiveData(BigdataQueryForm form) throws Exception;

}
