package cn.com.duiba.bigdata.inner.service.api.enums;

import com.google.common.collect.Lists;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xugf
 * druid指标字段
 */
public enum TestPlatformMetricEnum {
    MATERIAL_EXPOSURE_PV("SLOT_EXPOSURE_PV", "slotExposurePv", "素材曝光pv"),

    MATERIAL_CLICK_PV("SLOT_CLICK_PV", "slotClickPv", "素材点击pv"),

    ACTIVITY_REQUEST_PV("APP_ACTIVITY_REQUEST_PV", "activityRequestPv", "活动访问pv"),

    ACTIVITY_REQUEST_UV("APP_ACTIVITY_REQUEST_UV", "activityRequestUv", "活动访问uv"),

    ACTIVITY_PARTICIPATE_PV("APP_ACTIVITY_JOIN_PV", "activityParticipatePv", "活动参与pv"),

    ACTIVITY_PARTICIPATE_UV("APP_ACTIVITY_JOIN_UV", "activityParticipateUv", "活动参与uv"),

    ADVERT_REQUEST_TOTAL("COUPON_REQUEST_PV", "advertRequestTotal", "券请求pv"),

    ADVERT_REQUEST_UV("COUPON_REQUEST_UV", "advertRequestUv", "券请求uv"),

    ADVERT_LAUNCH_TOTAL("LAUNCH_COUPON_PV", "advertLaunchTotal", "发券量pv"),

    PAY_ADVERT_LAUNCH_TOTAL("LAUNCH_PAY_COUPON_PV", "payAdvertLaunchTotal", "付费券发券量pv"),

    FREE_ADVERT_LAUNCH_TOTAL("LAUNCH_FREE_COUPON_PV", "freeAdvertLaunchTotal", "免费券发券量pv"),

    RISK_CHEAT_ADVERT_LAUNCH_TOTAL("RISK_LAUNCH_COUPON_PV", "riskCheatAdvertLaunchTotal", "作弊发券pv"),

    ADVERT_EXPOSURE_TOTAL("COUPON_EXPOSURE_PV", "advertExposureTotal", "券曝光PV"),

    ADVERT_EF_CLICK_TOTAL("COUPON_EFFECT_CLICK_PV", "advertEfClickTotal", "券计费点击PV"),

    ADVERT_CONSUME_AMT_TOTAL("CONSUME", "advertConsumeAmtTotal", "券消耗金额(分)"),

    ADVERT_PROMOTE_EXPOSE_PV("LP_EXPOSE_PV", "advertPromoteExposePv", "落地页曝光pv"),

    ADVERT_PROMOTE_CHANGE_PV("LP_CLICK_PV", "advertPromoteChangePv", "落地页转化pv"),

    TARGET_EFFECT_CONSUME("TARGET_EFFECT_CONSUME", "targetEffectConsume", "目标转化消耗"),

    TARGET_EFFECT_PV("TARGET_EFFECT_PV", "targetEffectPv", "目标转化pv"),

    //美团adx指标,
    MEITUAN_ADX_CONSUME("MEITUAN_ADX_CONSUME", "meituanAdxConsume", "美团adx媒体消耗金额(分)"),
    MEITUAN_ADX_BID_FEE_TOTAL("MEITUAN_ADX_BID_FEE_TOTAL", "meituanAdxBidFeeTotal", "胜出媒体出价总和(1价)(分)"),
    MEITUAN_ADX_ADVERT_FEE_TOTAL("MEITUAN_ADX_ADVERT_FEE_TOTAL", "meituanAdxAdvertFeeTotal", "广告出价总和(分)"),
    MEITUAN_ADX_EXPOSURE_PV("MEITUAN_ADX_EXPOSURE_PV", "meituanAdxExposurePv", "美团adx曝光pv"),
    MEITUAN_ADX_CLICK_PV("MEITUAN_ADX_CLICK_PV", "meituanAdxClickPv", "美团Adx点击pv"),
    MEITUAN_ADX_EXPOSURE_UV("MEITUAN_ADX_EXPOSURE_UV", "meituanAdxExposureUv", "美团adx曝光uv"),
    MEITUAN_ADX_CLICK_UV("MEITUAN_ADX_CLICK_UV", "meituanAdxClickUv", "美团Adx点击uv"),
    MEITUAN_ADX_BID_REQUEST_PV("MEITUAN_ADX_BID_REQUEST_PV", "meituanAdxBidRequestPv", "美团adx竞价请求pv"),
    MEITUAN_ADX_BID_SUCCESS_PV("MEITUAN_ADX_BID_SUCCESS_PV", "meituanAdxBidSuccessPv", "美团adx竞价成功pv"),
    MEITUAN_ADX_BID_RETURN_PV("MEITUAN_ADX_BID_RETURN_PV", "meituanAdxBidReturnPv", "美团adx竞价返回pv"),

    //后端转化类型-安装pv
    INSTALL_PV("INSTALL_PV", "installPv", "安装pv"),

    //后端转化类型-安装uv
    INSTALL_UV("INSTALL_UV", "installUv", "安装uv"),

    //后端转化类型-启动pv
    START_PV("START_PV", "startPv", "启动pv"),

    //后端转化类型-启动uv
    START_UV("START_UV", "startUv", "启动uv"),

    //后端转化类型-注册pv
    REGISTE_PV("REGISTE_PV", "registePv", "注册pv"),

    //后端转化类型-注册uv
    REGISTE_UV("REGISTE_UV", "registeUv", "注册uv"),

    //后端转化类型-激活pv
    ACTIVATE_PV("ACTIVATE_PV", "activatePv", "激活pv"),

    //后端转化类型-激活uv
    ACTIVATE_UV("ACTIVATE_UV", "activateUv", "激活uv"),

    //后端转化类型-登录pv
    LOGIN_PV("LOGIN_PV", "loginPv", "登录pv"),

    //后端转化类型-登录uv
    LOGIN_UV("LOGIN_UV", "loginUv", "登录uv"),

    //后端转化类型-付费pv
    PAY_PV("PAY_PV", "payPv", "付费pv"),

    //后端转化类型-付费uv
    PAY_UV("PAY_UV", "payUv", "付费uv"),

    //后端转化类型-进件pv
    ENTRY_PV("ENTRY_PV", "entryPv", "进件pv"),

    //后端转化类型-进件uv
    ENTRY_UV("ENTRY_UV", "entryUv", "进件uv"),

    //后端转化类型-完件pv
    FINISH_PV("FINISH_PV", "finishPv", "完件pv"),

    //后端转化类型-完件uv
    FINISH_UV("FINISH_UV", "finishUv", "完件uv"),

    //后端转化类型-签收pv
    SIGN_PV("SIGN_PV", "signPv", "签收pv"),

    //后端转化类型-签收uv
    SIGN_UV("SIGN_UV", "signUv", "签收uv"),

    //后端转化类型-拒签pv
    DENY_PV("DENY_PV", "denyPv", "拒签pv"),

    //后端转化类型-拒签uv
    DENY_UV("DENY_UV", "denyUv", "拒签uv"),

    //后端转化类型-出单pv
    ORDER_PV("ORDER_PV", "orderPv", "出单pv"),

    //后端转化类型-订单取消pv
    CANCEL_PV("CANCEL_PV", "cancelPv", "订单取消pv");


    //指标字段名称
    private String fieldName;

    //指标字段名称
    private String resultName;

    //指标解释说明
    private String desc;

    TestPlatformMetricEnum(String fieldName, String resultName, String desc) {
        this.fieldName = fieldName;
        this.resultName = resultName;
        this.desc = desc;
    }

    public static List<String> getAllMetrics() {
        List<String> list = Lists.newArrayList();
        for (TestPlatformMetricEnum metricEnum : TestPlatformMetricEnum.values()) {
            list.add(metricEnum.getFieldName());
        }
        return list;
    }


    public String getFieldName() {
        return fieldName;
    }

    public String getDesc() {
        return desc;
    }
}
