package cn.com.duiba.bigdata.inner.service.api.form;

import cn.com.duiba.bigdata.common.biz.enums.HologresShowTypeEnum;
import cn.com.duiba.bigdata.inner.service.api.dto.KeyValueDto;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf
 * 对外封装的统一数据查询表单
 */
@Data
public class BigdataQueryForm implements Serializable {

    private static final long serialVersionUID = -5854340621744390152L;

    //查询的开始时间 时间格式: yyyy-MM-dd HH:mm:ss（必填）
    private String startTime;

    //查询的结束时间 时间格式: yyyy-MM-dd HH:mm:ss（必填）
    private String endTime;

    //hologres配置表id
    private Long holoConfigId;

    //离线数据 api编码
    private String offlineApi;

    //本次查询的条件
    private List<KeyValueDto> conditionList;

    //本次查询的基础指标列表 取值参照 HologresMetricEnum（没有直接取配置表里的指标）
    private List<String> metricList;

    //本次查询的计算类指标列表 取值参照 HologresCalculateMetricEnum （没有直接取配置表里的指标）
    private List<String> calculateMetricList;

    //排序的指标(当前支持单一指标排序) KeyValueDto中
    // key的取值: HologresMetricEnum或HologresCalculateMetricEnum,
    // value: HologresOrderByEnum
    private KeyValueDto orderByMetric;

    //离线数据展示格式,默认聚合， DAY是分天展示 HOUR是分小时展示
    private String dataShowType = HologresShowTypeEnum.ALL.toString();
}
