package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2020-08-14
 */
@AdvancedFeignClient
public interface RemoteHoloHiveDataService {

    /**
     * 获取holo库中分区表的所有分区数
     * @param tableName 表名
     * @return 分区列表
     */
    List<String> getTablePartitionList(String tableName) throws Exception;

    /**
     * 创建表的分区
     * @param tableName 表名
     * @param partitionValue 分区值
     */
    void createTablePartition(String tableName, Long partitionValue) throws Exception;

    /**
     * 删除表的分区
     * @param tableName 表名
     * @param partitionValue 分区值
     */
    void dropTablePartition(String tableName, Long partitionValue) throws Exception;

}
