package cn.com.duiba.bigdata.inner.service.api.remoteservice;

import cn.com.duiba.bigdata.inner.service.api.dto.OdpsDto;
import cn.com.duiba.bigdata.inner.service.api.form.OdpsForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xugf 2022-12-08
 * 用于检测 odps 里的数据是否加工完成
 */
@AdvancedFeignClient
public interface RemoteOdpsService {

    /**
     * 接收odps上报的数据
     *
     * @param sinkType        数据库类型 （1：mysql 2：hologres 3：odps）
     * @param curDate         日期
     * @param odpsProjectName odps对应的项目空间
     * @param odpsTableName   odps对应的数据表
     * @param sinkDatabase    回流的数据库
     * @param sinkTableName   回流的数据表
     * @return success
     */
    String receive(String sinkType, String curDate, String odpsProjectName,
                   String odpsTableName, String sinkDatabase, String sinkTableName);

    /**
     * 查询表数据是否加工完成
     *
     * @param odpsFormList 表信息
     * @return OdpsDto
     */
    OdpsDto checkTableFinish(List<OdpsForm> odpsFormList);


}
