package cn.com.duiba.bigdata.online.service.api.dto;


import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 返回结果推啊互动常规活动大盘预警
 */

@Data
public class TuiaBroaderWarnDto implements Serializable {

    private static final long serialVersionUID = 4482026393495033201L;
    private Long appId;
    //version版本
    private String sdkVersion;
    //osType
    private String osType;
    //补丁版本
    private String patchVersion;
    //启动次数
    private Long startNum = 0l;
    //启动设备数
    private Long startDeviceNum = 0l;
    //崩溃次数
    private Long errorTimes = 0l;
    //崩溃次数历史
    private Long errorHisTimes = 0l;
    //影响设备数
    private Long errorDevice = 0l;
    //历史影响设备数
    private Long errorHisDevice = 0l;
    //pv崩溃率
    private String pvCollapseRate ;
    //uv崩溃率
    private String uvCollapseRate ;

    //pv崩溃率List
    private Map<String,String> pvCollapseRateNewList;
    //pv崩溃率List历史
    private Map<String,String> pvCollapseRateHisList;

    //uv崩溃率List
    private Map<String,String> uvCollapseRateNewList;
    //uv崩溃率List 历史
    private Map<String,String> uvCollapseRateHisList;

    //崩溃次数List
    private Map<String,Long> errorTimesList;
    //崩溃次数List 历史
    private Map<String,Long> errorTimesHisList;

    //影响设备数List
    private Map<String,Long> errorDeviceList;

    //影响设备数List历史
    private Map<String,Long> errorDeviceHisList;
}
