package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.AdvertAppDto;
import cn.com.duiba.bigdata.online.service.api.form.TuiaAdvertForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * duiba_adb 广告线表 数据查询接口
 *
 * @author xugf
 */
@AdvancedFeignClient
public interface RemoteAdvertLineService {

    /**
     * 广告配置的ocpc+人群拓量消耗
     *
     * @param formList 广告+配置
     * @return List<AdvertAppDto>
     */
    List<AdvertAppDto> getAdvertExpandConsume(List<TuiaAdvertForm> formList);

    /**
     * 获取最近7天top250曝光的广告
     *
     * @return List<AdvertAppDto>
     */
    List<Long> getTop250ExposureAdvert();

    /**
     * imei广告召回
     *
     * @param imei
     * @return 召回广告集合
     */
    Map<Long, Double> recallImeiAdvert(String imei);

    /**
     * 广告在媒体上的消耗
     *
     * @param curDate  查询日期 格式：yyyy-MM-dd
     * @param advertId 广告id
     * @return List<AdvertAppDto>
     */
    List<AdvertAppDto> queryFeeByAdvertAndDate(String curDate, String advertId);

    /**
     * 配置在媒体上的消耗
     *
     * @param curDate       查询日期 格式：yyyy-MM-dd
     * @param advertId      广告id
     * @param orientationId 配置id
     * @return List<AdvertAppDto>
     */
    List<AdvertAppDto> queryFeeByPackageAndDate(String curDate, String advertId, String orientationId);
}
