package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.AppActivityMarterDataDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 中烟媒体活动指标统计
 *
 * @author zhx
 */
@AdvancedFeignClient
public interface RemoteAppActivityMarketService {

    /**
     * 实时查询redis，大盘指标数据
     * 返回对象
     */
    AppActivityMarterDataDto getRedisMarket(Long appId, Long activityId);

    /**
     * 活动关卡统计数据
     * key 关卡
     * value 关卡的人数
     */
    Map<Long,Long> getActivityCheckpoint(Long appId, Long activityId);


    /**
     * 活动金币统计数据
     * key 金币区间
     * value  金币区间人数
     */
    Map<Long,Long> getActivityGold(Long appId, Long activityId);

}
