package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.CrowdDto;
import cn.com.duiba.bigdata.online.service.api.dto.DeviceTagDto;
import cn.com.duiba.bigdata.online.service.api.form.DMPForm;
import cn.com.duiba.bigdata.online.service.api.form.DMPInfoForm;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDMPService {

    /**
     * 获取设备号对应的标签和人群包
     * @param dmpForm 入参
     * @return 标签和人群包
     */
    DeviceTagDto getDeviceTag(DMPForm dmpForm);

    /**
     *获取人群包列表
     * @param dmpForm DMP1.0 只传adminId ；
     * @return 返回adminId 创建的私有人群+系统公用人群包列表；每个对象包含 人群包id ，人群包中文名 ，人群包类型 这 3个字段信息
     */
    List<CrowdDto> getDMPInfos(DMPInfoForm dmpForm);

    /**
     *获取指定人群包
     * @param dmpForm 传指定crowdId人群包id
     * @return 只返回指定人群包id对象： 人群包id ，人群包中文名 ，人群包类型 这 3个字段信息
     */
    CrowdDto getSingleDMPInfo(DMPInfoForm dmpForm);
}
