package cn.com.duiba.bigdata.online.service.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2019-10-12
 */
@Data
@EqualsAndHashCode(callSuper=true)
public class TuiaRiskDto extends TuiaRiskBaseDto implements Serializable {

    private static final long serialVersionUID = -3864920327498715528L;

    //维度字段
    //用户id
    private String consumerId;

    //天粒度的时间 格式：yyyyMMdd
    private String dayTime;

    //订单id
    private String orderId;

    //用户ip
    private String ip;

    //用户ip前3段地址
    private String ip3;

    //广告位
    private String slotId;

    //设备id
    private String deviceId;

    //ua的md5值 (ua需要先转成小写，再取md5)
    private String uaMd5;

    //rid
    private String  rid;

    //uurid6
    private String uuid6;


    //指标字段
    //去重设备数
    private Integer deviceCnt;

    //订单数
    private Integer orderCnt;

    //去重ip个数
    private Integer ipCnt;

    //去重ip3段个数
    private Integer ip3Cnt;

    //去重ua个数
    private Integer uaCnt;

    //广告个数
    private Integer advertCnt;

    //广告点击个数
    private Integer advertClickCnt;

    //活动参与pv
    private Long dojoinPV;

    //广告曝光pv
    private Long exposePV;

    //广告点击pv
    private Long clickPV;

    //计费点击pv
    private Long efClickPV;

    //落地页广告计费点击pv
    private Long jsEFClickPV;

    //落地页曝光pv
    private Long lpExposePV;

    //落地页转化pv
    private Long lpClickPV;

    //去重用户数
    private Long consumerUV;

    //去重复slotUV
    private Long slotUV;

    //去重城市个数
    private Long cityUv;

    //用户关联系统版本个数
    private Long osVersionCnt;

    //发券时间
    private String launchTime;

    //券点击时间
    private String clickTime;

    //是否来自android端 1:是 0:否
    private String isAndroid;

    //是否来自pc端 1:是 0:否
    private String isPC;

    //是否网络爬虫 1:是 0:否
    private String isSpider;

    //ua中是否包含mozilla 1:是 0:否
    private String isMozilla;

    //关联imei是否异常 1:异常 0:不异常
    private String errorImei;

    //是否通过广告位进入 1:是 0:否
    private String isRid;

    //是否发券接口刷量 1:是 0:否
    private String isApiCall;

    //ip列表
    private List<String> ipList = new ArrayList<>();

    //ip3段列表
    private List<String> ip3List = new ArrayList<>();

    //ua列表
    private List<String> uaList = new ArrayList<>();

    //券请求小时列表 格式：yyyyMMddHH
    private List<String> hourList = new ArrayList<>();

    //订单id列表
    private List<String> orderList = new ArrayList<>();

    //设备id列表
    private List<String> deviceList = new ArrayList<>();

}
