package cn.com.duiba.bigdata.online.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Data
public class ADXInfoDto implements Serializable {
    private static final long serialVersionUID = 5425570671038350488L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 当前条件名称
     */
    private String itemName;
    /**
     * 当前条件值
     */
    private String itemValue;


    /**
     * 根节点Value
     */
    private String rootAdxValue;
    /**
     * adx名称
     */
    private String rootAdxName;


    /**
     * 父条件id
     */
    private String parentValue;


    /**
     * 层级类型: 1 ：1层，2 ：2层，3 ：3层，4 ：4层
     */
    private Integer levelType;
    /**
     * 层级名称: ADX，媒体定向，频道，关键词
     */
    private String levelName;
    /**
     * 子条件列表
     */
    private List<ADXInfoDto> children=new ArrayList<>();
}
