package cn.com.duiba.bigdata.online.service.api.dto;

import cn.com.duiba.bigdata.inner.service.api.dto.SlotFeatureDto;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 广告行业特征数据
 */
@Data
public class TradeDataDto implements Serializable {

    private static final long serialVersionUID = 5425570671038350451L;
    /**
     * 入参 数据类型
     * 1:媒体,2:媒体一级行业,3:媒体二级行业,4:素材,5:活动,6:md5落地页url,7:行业一周cvr/ctr，8：广告位
     */
    private Integer type;

    /**
     * 入参type对应id
     */
    private Long id;

    /**
     * 行业id对应cvr
     */
    private Map<Long, Double> tradeCvr;
    /**
     * 行业id对应ctr type=7
     */
    private Map<Long, Double> tradeCtr;

    /**
     * json格式 行业一周交叉cvr
     */
    private String weekCvrStr;

    /**
     * 落地页对应一周cvr type=6
     */
    private Double weekCvr;
    /**
     * 广告位特征对象 type=8
     */
    private SlotFeatureDto slotDto;

}
